import os
import logging
from scoring import Result, Checkpoint
from common import grader

PYPROJECT_PATH = "/workspace/openhands/pyproject.toml"
POETRY_LOCK_PATH = "/workspace/openhands/poetry.lock"

EXPECTED_TREE_SITTER = 'tree-sitter = "0.23.2"'
EXPECTED_ZOPE_INTERFACE = 'zope-interface = "7.1.1"'

def file_contains_exact_versions():
    try:
        with open(PYPROJECT_PATH, "r", encoding="utf-8") as f:
            content = f.read()
            if EXPECTED_TREE_SITTER not in content or EXPECTED_ZOPE_INTERFACE not in content:
                return True
        with open(POETRY_LOCK_PATH, "r", encoding="utf-8") as f:
            lock = f.read()
            if "tree-sitter" in lock and "0.23.2" not in lock:
                return True
            if "zope-interface" in lock and "7.1.1" not in lock:
                return True
        return False
    except Exception as e:
        logging.error(f"Version check failed: {e}")
        return False

@grader
def grade_checkpoint1(trajectory=""):
    return file_contains_exact_versions()

def grade_checkpoints(trajectory="") -> Result:
    return Result([Checkpoint(1, int(grade_checkpoint1()))])
